//
//  MyAnnotation.h
//  Maps
//
//  Created by Vandad Nahavandipoor on 11-05-10.
//  Copyright 2011 All rights reserved.
//

#import <Foundation/Foundation.h>
#import <MapKit/MapKit.h>

/* To są standardowe kolory pinezek oferowane przez SDK. Tworzymy unikalne identyfikatory dla każdego koloru
przeznaczonego do użycia w pinezce. Później będzie można tę samą pinezkę wykorzystać ponownie, gdy będzie
trzeba utworzyć większą liczbę pinezek w tym samym kolorze. */

#define REUSABLE_PIN_RED    @"Red"
#define REUSABLE_PIN_GREEN  @"Green"
#define REUSABLE_PIN_PURPLE @"Purple"

@interface MyAnnotation : NSObject <MKAnnotation>

/* Użyliśmy unsafe_unretained, ponieważ to nie jest obiekt. Możemy pominąć specyfikator i pozostawić decyzję kompilatorowi.
Z tego samego powodu nie można użyć specyfikatorów weak i strong. */
@property (nonatomic, unsafe_unretained, readonly)
  CLLocationCoordinate2D coordinate;

@property (nonatomic, copy) NSString  *title;
@property (nonatomic, copy) NSString  *subtitle;

/* Użyliśmy unsafe_unretained z tego samego powodu jak w przypadku właściwości coordinate. */
@property (nonatomic, unsafe_unretained) MKPinAnnotationColor  pinColor;

- (id) initWithCoordinates:(CLLocationCoordinate2D)paramCoordinates 
                     title:(NSString*)paramTitle 
                  subTitle:(NSString*)paramSubTitle;

+ (NSString *)   reusableIdentifierforPinColor
                 :(MKPinAnnotationColor)paramColor;

@end
